/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.compiler;

import com.ochafik.io.ReadText;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.tools.FileObject;

public class URLFileObject
implements FileObject {
    URL url;

    public URLFileObject(URL url) {
        this.url = url;
    }

    public String getPath() {
        return this.url.getFile();
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return ReadText.readText(this.url);
    }

    @Override
    public long getLastModified() {
        try {
            URLConnection con = this.url.openConnection();
            long lastModified = con.getLastModified();
            con.getInputStream().close();
            return lastModified;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1L;
        }
    }

    @Override
    public String getName() {
        return new File(this.url.getFile()).getName();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.url.openStream();
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return null;
    }

    @Override
    public Reader openReader(boolean arg0) throws IOException {
        return new InputStreamReader(this.openInputStream());
    }

    @Override
    public Writer openWriter() throws IOException {
        return null;
    }

    @Override
    public URI toUri() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

