/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.compiler;

import com.ochafik.io.IOUtils;
import com.ochafik.lang.compiler.MemoryFileObject;
import com.ochafik.lang.compiler.MemoryJavaFile;
import com.ochafik.lang.compiler.URLFileObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class MemoryFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    public final Map<String, MemoryJavaFile> inputs = new HashMap<String, MemoryJavaFile>();
    public final Map<String, FileObject> outputs = new HashMap<String, FileObject>();

    public void writeJar(File outputJar, boolean outputSources, Map<String, File> additionalFiles) throws IOException {
        File jarDir = outputJar.getAbsoluteFile().getParentFile();
        if (!jarDir.isDirectory()) {
            jarDir.mkdirs();
        }
        this.writeJar(new FileOutputStream(outputJar), outputSources, additionalFiles);
    }

    public void writeJar(OutputStream out, boolean outputSources, Map<String, File> additionalFiles) throws IOException {
        JarOutputStream jout = new JarOutputStream(out);
        if (outputSources) {
            for (Map.Entry<String, FileObject> entry : this.inputs.entrySet()) {
                this.writeEntry(entry.getKey(), entry.getValue(), jout);
            }
        }
        for (Map.Entry<String, FileObject> entry : this.outputs.entrySet()) {
            this.writeEntry(entry.getKey(), entry.getValue(), jout);
        }
        if (additionalFiles != null) {
            for (Map.Entry<String, Object> entry : additionalFiles.entrySet()) {
                String path = entry.getKey();
                if (path.startsWith("file:///")) {
                    path = path.substring("file:///".length());
                }
                FileInputStream in = new FileInputStream((File)entry.getValue());
                JarEntry e = new JarEntry(path);
                jout.putNextEntry(e);
                IOUtils.readWrite(in, jout);
                in.close();
                jout.closeEntry();
            }
        }
        jout.close();
    }

    protected void writeEntry(String path, FileObject o, JarOutputStream jout) throws IOException {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("file:///")) {
            path = path.substring("file:///".length());
        }
        if (o instanceof MemoryFileObject) {
            MemoryFileObject mo = (MemoryFileObject)o;
            byte[] c = mo.getContent();
            if (c == null) {
                return;
            }
            JarEntry e = new JarEntry(path);
            jout.putNextEntry(e);
            jout.write(c);
            jout.closeEntry();
        } else if (o instanceof URLFileObject) {
            URLFileObject uo = (URLFileObject)o;
            JarEntry e = new JarEntry(path);
            jout.putNextEntry(e);
            InputStream in = uo.url.openStream();
            if (in == null) {
                throw new FileNotFoundException(path);
            }
            IOUtils.readWrite(in, jout);
            in.close();
            jout.closeEntry();
        } else {
            throw new UnsupportedOperationException("Dunno how to deal with " + o);
        }
    }

    public MemoryFileManager(JavaFileManager fm) {
        super(fm);
    }

    public MemoryJavaFile addSourceInput(String path, String content) {
        if (!path.startsWith("file:///")) {
            path = "file:///" + path;
        }
        MemoryJavaFile mjf = new MemoryJavaFile(path, content, JavaFileObject.Kind.SOURCE);
        this.inputs.put(path, mjf);
        return mjf;
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a.toString().equals(b.toString());
    }

    public Iterable<? extends JavaFileObject> getJavaFileObjects() {
        return new ArrayList<MemoryJavaFile>(this.inputs.values());
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        if (kind == JavaFileObject.Kind.SOURCE) {
            return this.inputs.get(className);
        }
        return super.getJavaFileForInput(location, className, kind);
    }

    public static String getFullPathForClass(String className, String extension) {
        return "file:///" + MemoryFileManager.getSimplePathForClass(className, extension);
    }

    public static String getSimplePathForClass(String className, String extension) {
        return className.replace('.', '/') + "." + extension;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavaFileObject jo = null;
        if (kind == JavaFileObject.Kind.CLASS) {
            jo = new MemoryJavaFile(MemoryFileManager.getFullPathForClass(className, "class"), null, kind);
            this.outputs.put(MemoryFileManager.getFullPathForClass(className, "class"), jo);
        } else if (kind == JavaFileObject.Kind.SOURCE) {
            jo = new MemoryJavaFile(MemoryFileManager.getFullPathForClass(className, "java"), null, kind);
            this.inputs.put(MemoryFileManager.getFullPathForClass(className, "java"), (MemoryJavaFile)jo);
        }
        return jo == null ? super.getJavaFileForInput(location, className, kind) : jo;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        FileObject out;
        if (relativeName.startsWith("file:///")) {
            relativeName = relativeName.substring("file:///".length());
        }
        if ((out = this.outputs.get(relativeName)) == null) {
            out = new MemoryFileObject(relativeName, (String)null);
            this.outputs.put(relativeName, out);
        }
        return out;
    }
}

