/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.compiler;

import com.ochafik.io.IOUtils;
import com.ochafik.lang.compiler.MemoryFileManager;
import com.ochafik.lang.compiler.MemoryJavaFile;
import com.ochafik.util.listenable.Adapter;
import com.ochafik.util.string.RegexUtils;
import com.ochafik.util.string.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public class CompilerUtils {
    static Map<String, File> localURLCaches = new HashMap<String, File>();

    public static String getClassPath(Class<?> c, File cacheDirectory) throws MalformedURLException, IOException {
        URL resource = c.getResource(c.getSimpleName() + ".class");
        if (resource != null) {
            String resstr = resource.toString();
            if (resstr.matches("jar:.*!.*")) {
                resstr = resstr.substring("jar:".length(), resstr.indexOf("!"));
            } else {
                String p = '/' + c.getName().replace('.', '/') + ".class";
                if (resstr.endsWith(p)) {
                    resstr = resstr.substring(0, resstr.length() - p.length());
                }
            }
            return CompilerUtils.getLocalFile(new URL(resstr), cacheDirectory).toString();
        }
        return null;
    }

    public static Set<String> getClassPaths(File cacheDirectory, Class<?> ... cs) throws MalformedURLException, IOException {
        TreeSet<String> ret = new TreeSet<String>();
        for (Class<?> c : cs) {
            String cp;
            if (c == null || (cp = CompilerUtils.getClassPath(c, cacheDirectory)) == null) continue;
            ret.add(cp);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getLocalFile(URL remoteFile, File cacheDirectory) throws IOException {
        if ("file".equals(remoteFile.getProtocol())) {
            return new File(URLDecoder.decode(remoteFile.getFile(), "utf-8"));
        }
        String remoteStr = remoteFile.toString();
        File f = localURLCaches.get(remoteStr);
        if (f == null) {
            String fileName = new File(remoteStr).getName();
            URLConnection con = null;
            try {
                con = remoteFile.openConnection();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (cacheDirectory != null) {
                f = new File(cacheDirectory, fileName);
                if (f.exists() && (con == null || f.lastModified() > con.getLastModified())) {
                    System.out.println("Reusing cached file " + f);
                    if (con != null) {
                        con.getInputStream().close();
                    }
                    return f;
                }
            } else {
                f = File.createTempFile(fileName, ".jar");
                f.deleteOnExit();
            }
            System.out.print("Downloading file " + remoteFile + " to " + f);
            BufferedInputStream in = new BufferedInputStream(remoteFile.openStream());
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
                try {
                    long length = IOUtils.readWrite(in, out);
                    System.out.println(" OK (" + length + " bytes)");
                    localURLCaches.put(remoteStr, f.getAbsoluteFile());
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
        return f;
    }

    public static void compile(JavaCompiler compiler, MemoryFileManager fileManager, DiagnosticCollector<JavaFileObject> diagnostics, String sourceCompatibility, File cacheDirectory, Class<?> ... classpathHints) throws MalformedURLException, IOException {
        Set<String> bootclasspaths = CompilerUtils.getClassPaths(cacheDirectory, classpathHints);
        bootclasspaths.addAll(CompilerUtils.getClassPaths(cacheDirectory, String.class));
        String bootclasspath = StringUtils.implode(bootclasspaths, (Object)File.pathSeparator);
        Iterable<? extends JavaFileObject> fileObjects = fileManager.getJavaFileObjects();
        List<String> options = sourceCompatibility == null ? null : Arrays.asList("-target", sourceCompatibility, "-source", sourceCompatibility, "-bootclasspath", bootclasspath, "-classpath", bootclasspath);
        compiler.getTask(null, fileManager, diagnostics, options, null, fileObjects).call();
    }

    public static JavaCompiler getJavaCompiler(boolean preferJavac) throws FileNotFoundException {
        JavaCompiler compiler;
        block3: {
            if (preferJavac && (compiler = ToolProvider.getSystemJavaCompiler()) != null) {
                return compiler;
            }
            try {
                compiler = (JavaCompiler)Class.forName("org.eclipse.jdt.internal.compiler.tool.EclipseCompiler").newInstance();
            }
            catch (Exception e) {
                compiler = ToolProvider.getSystemJavaCompiler();
                if (compiler != null) break block3;
                throw new FileNotFoundException("No Java compiler found (not run from JDK, no Eclipse Compiler in classpath)");
            }
        }
        return compiler;
    }

    public static void main2(String[] args) {
        try {
            String jarOut = args.length == 0 ? "out.jar" : args[0];
            JavaCompiler compiler = CompilerUtils.getJavaCompiler(false);
            DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
            MemoryFileManager fileManager = new MemoryFileManager(compiler.getStandardFileManager(diagnostics, null, null));
            fileManager.addSourceInput("test/Main.java", "package test; public class Main { }");
            fileManager.close();
            CompilerUtils.compile(compiler, fileManager, diagnostics, null, null, new Class[0]);
            for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
                System.out.format("Error on line " + diagnostic.getLineNumber() + ":" + diagnostic.getLineNumber() + " in " + diagnostic.getSource(), new Object[0]);
            }
            boolean outputSources = true;
            System.out.println("Writing " + jarOut + (outputSources ? " with" : " without") + " sources");
            fileManager.writeJar(new FileOutputStream(jarOut), outputSources, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static class CompilationError
    extends IOException {
        private static final long serialVersionUID = 4002559714569792833L;
        public final String compilerClass;
        public final List<Diagnostic<? extends JavaFileObject>> diagnostics;
        public final Map<String, MemoryJavaFile> inputs;

        private CompilationError(String text, List<Diagnostic<? extends JavaFileObject>> diagnostics, Map<String, MemoryJavaFile> inputs, String compilerClass) {
            super(text);
            this.diagnostics = diagnostics;
            this.inputs = inputs;
            this.compilerClass = compilerClass;
        }

        public static void throwErrors(List<Diagnostic<? extends JavaFileObject>> diagnostics, Map<String, MemoryJavaFile> inputs, String compilerClass) throws CompilationError, IOException {
            ArrayList<Diagnostic<? extends JavaFileObject>> errors = new ArrayList<Diagnostic<? extends JavaFileObject>>(diagnostics.size());
            StringBuilder sb = new StringBuilder();
            for (final Diagnostic<? extends JavaFileObject> diagnostic : diagnostics) {
                if (diagnostic == null || diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                errors.add(diagnostic);
                sb.append("Error in " + diagnostic.getSource().toUri() + " at line " + diagnostic.getLineNumber() + ", col " + diagnostic.getColumnNumber() + " :\n\t" + diagnostic.getMessage(Locale.getDefault()) + "\n");
                sb.append(RegexUtils.regexReplace(Pattern.compile("\n"), "\n" + diagnostic.getSource().getCharContent(true), new Adapter<String[], String>(){
                    int line = 0;

                    @Override
                    public String adapt(String[] value) {
                        ++this.line;
                        return "\n" + this.line + ":" + (diagnostic.getLineNumber() == (long)this.line ? ">>>" : "") + "\t\t";
                    }
                }) + "\n");
            }
            if (errors.isEmpty()) {
                return;
            }
            System.err.println("INPUTS = " + inputs);
            throw new CompilationError(sb.toString(), errors, inputs, compilerClass);
        }
    }
}

