/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.beans;

import com.ochafik.swing.FormUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class BeansController<M> {
    M model;
    Class<M> modelClass;
    Map<String, List<JComponent>> viewsByPropertyName = new HashMap<String, List<JComponent>>();
    Map<String, Class> propertiesTypes = new HashMap<String, Class>();
    Map<String, Object> oldValues = new HashMap<String, Object>();
    Map<String, Method> getterMethods = new HashMap<String, Method>();
    Map<String, Method> setterMethods = new HashMap<String, Method>();
    PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    static final Class[] getterArgs = new Class[0];
    public static final boolean booleanTrue = true;
    boolean updatingModel = false;
    boolean firingPropertyChange = false;
    Set<String> propertiesBeingFired = new TreeSet<String>();

    public BeansController(Class<M> modelClass) {
        this.modelClass = modelClass;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public JComponent createScrollableViewComponent(String propertyName, String caption, String title, String tooltip, boolean largeComponent) {
        JComponent c = this.createViewComponent(propertyName, caption, largeComponent);
        if (c == null) {
            return c;
        }
        if (title != null) {
            c.setBorder(BorderFactory.createTitledBorder(title));
        }
        if (c instanceof JTextArea) {
            JTextArea ta = (JTextArea)c;
            ta.setLineWrap(true);
            ta.setWrapStyleWord(true);
            JScrollPane jsp = new JScrollPane(ta);
            c = jsp;
        }
        if (title != null) {
            c.setBorder(BorderFactory.createTitledBorder(title));
        }
        if (tooltip != null) {
            c.setToolTipText(tooltip);
        }
        return c;
    }

    public JComponent createViewComponent(String propertyName, String caption, boolean largeComponent) {
        try {
            JComponent jc;
            Class propertyType = this.getPropertyType(propertyName);
            if (String.class.isAssignableFrom(propertyType)) {
                jc = largeComponent ? new JTextArea() : new JTextField();
                final JTextComponent jtc = jc;
                FormUtils.addUndoRedoSupport(jtc);
                jtc.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent arg0) {
                        jtc.selectAll();
                    }

                    @Override
                    public void focusLost(FocusEvent arg0) {
                        jtc.setSelectionStart(0);
                        jtc.setSelectionEnd(0);
                    }
                });
            } else if (BeansController.isBoolean(propertyType)) {
                jc = caption == null ? new JCheckBox() : new JCheckBox(caption);
            } else if (BeansController.isInteger(propertyType)) {
                jc = new JTextField();
            } else {
                System.err.println("IMPLEMENTME! Don't know how to create a view component for model class " + propertyType.getName());
                jc = null;
            }
            this.attachViewComponent(jc, propertyName);
            return jc;
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("No such field in " + this.modelClass.getName() + " : " + propertyName);
        }
    }

    public void attachViewComponent(JComponent jc, String propertyName) throws NoSuchMethodException {
        JComponent c;
        Class propertyType = this.getPropertyType(propertyName);
        if (String.class.isAssignableFrom(propertyType)) {
            c = (JTextComponent)jc;
            ((JTextComponent)c).getDocument().addDocumentListener(new DocumentListener((JTextComponent)c, propertyName){
                final /* synthetic */ JTextComponent val$c;
                final /* synthetic */ String val$propertyName;
                {
                    this.val$c = jTextComponent;
                    this.val$propertyName = string;
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    BeansController.this.fireViewChange(this.val$c, this.val$propertyName, this.val$c.getText());
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    BeansController.this.fireViewChange(this.val$c, this.val$propertyName, this.val$c.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    BeansController.this.fireViewChange(this.val$c, this.val$propertyName, this.val$c.getText());
                }
            });
        } else if (BeansController.isBoolean(propertyType)) {
            c = (AbstractButton)jc;
            ((AbstractButton)c).addActionListener(new ActionListener((AbstractButton)c, propertyName){
                final /* synthetic */ AbstractButton val$c;
                final /* synthetic */ String val$propertyName;
                {
                    this.val$c = abstractButton;
                    this.val$propertyName = string;
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BeansController.this.fireViewChange(this.val$c, this.val$propertyName, new Boolean(this.val$c.isSelected()));
                }
            });
        } else if (BeansController.isInteger(propertyType)) {
            c = (JTextComponent)jc;
            ((JTextComponent)c).getDocument().addDocumentListener(new DocumentListener((JTextComponent)c, propertyName){
                final /* synthetic */ JTextComponent val$c;
                final /* synthetic */ String val$propertyName;
                {
                    this.val$c = jTextComponent;
                    this.val$propertyName = string;
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    BeansController.this.fireViewChange(this.val$c, this.val$propertyName, this.val$c.getText());
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    BeansController.this.fireViewChange(this.val$c, this.val$propertyName, this.val$c.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    BeansController.this.fireViewChange(this.val$c, this.val$propertyName, this.val$c.getText());
                }
            });
        } else {
            System.err.println("IMPLEMENTME! Don't know how to create a view component for model class " + propertyType.getName());
        }
        if (jc != null) {
            List<JComponent> views = this.viewsByPropertyName.get(propertyName);
            if (views == null) {
                views = new ArrayList<JComponent>();
                this.viewsByPropertyName.put(propertyName, views);
            }
            views.add(jc);
        }
        jc.setEnabled(this.model != null);
    }

    Method getGetterMethod(String propertyName) throws NoSuchMethodException {
        Method getterMethod = this.getterMethods.get(propertyName);
        if (getterMethod == null) {
            try {
                getterMethod = this.modelClass.getMethod(BeansController.getGetterMethodName(propertyName), getterArgs);
            }
            catch (NoSuchMethodException ex) {
                getterMethod = this.modelClass.getMethod(BeansController.getIsGetterMethodName(propertyName), getterArgs);
            }
            this.getterMethods.put(propertyName, getterMethod);
        }
        return getterMethod;
    }

    Class getPropertyType(String propertyName) throws NoSuchMethodException {
        Class<?> propertyType = this.propertiesTypes.get(propertyName);
        if (propertyType == null) {
            propertyType = this.getGetterMethod(propertyName).getReturnType();
            this.propertiesTypes.put(propertyName, propertyType);
        }
        return propertyType;
    }

    Method getSetterMethod(String propertyName) throws NoSuchMethodException {
        Method setterMethod = this.setterMethods.get(propertyName);
        if (setterMethod == null) {
            Class propertyType = this.getPropertyType(propertyName);
            Class[] setterArgs = new Class[]{propertyType};
            setterMethod = this.modelClass.getMethod(BeansController.getSetterMethodName(propertyName), setterArgs);
            this.setterMethods.put(propertyName, setterMethod);
        }
        return setterMethod;
    }

    public M getModel() {
        return this.model;
    }

    public void setModel(M model) {
        this.model = model;
        if (model != null && !this.modelClass.isAssignableFrom(model.getClass())) {
            throw new ClassCastException(model.getClass().getName() + " not a subclass of " + this.modelClass.getName());
        }
        this.modelUpdated();
    }

    /*
     * Unable to fully structure code
     */
    public void fireViewChange(Component eventSource, String propertyName, Object newValue) {
        if (this.updatingModel) {
            return;
        }
        if (this.propertiesBeingFired.contains(propertyName)) {
            return;
        }
        this.propertiesBeingFired.add(propertyName);
        if (this.model != null) {
            try {
                propertyType = this.getPropertyType(propertyName);
                oldValue = this.oldValues.get(propertyName);
                validValue = true;
                if (String.class.isAssignableFrom(propertyType)) {
                    this.getSetterMethod(propertyName).invoke(this.model, new Object[]{newValue});
                    this.oldValues.put(propertyName, newValue);
                    for (JComponent view : this.viewsByPropertyName.get(propertyName)) {
                        if (view == eventSource) continue;
                        tc = (JTextComponent)view;
                        tc.setText((String)newValue);
                    }
                } else if (BeansController.isBoolean(propertyType)) {
                    this.getSetterMethod(propertyName).invoke(this.model, new Object[]{newValue});
                    this.oldValues.put(propertyName, newValue);
                    for (JComponent view : this.viewsByPropertyName.get(propertyName)) {
                        if (view == eventSource) continue;
                        cb = (AbstractButton)view;
                        cb.setSelected((Boolean)newValue);
                    }
                } else if (BeansController.isInteger(propertyType)) {
                    try {
                        intValue = Integer.parseInt(((String)newValue).trim());
                        this.getSetterMethod(propertyName).invoke(this.model, new Object[]{new Integer(intValue)});
                        this.oldValues.put(propertyName, newValue);
                        for (JComponent view : this.viewsByPropertyName.get(propertyName)) {
                            view.setFont(view.getFont().deriveFont(0));
                            view.setForeground(Color.black);
                            if (view == eventSource) continue;
                            tc = (JTextComponent)view;
                            tc.setText(intValue + "");
                        }
                    }
                    catch (NumberFormatException ex) {
                        validValue = false;
                        if (!(eventSource instanceof Component)) ** GOTO lbl55
                        eventSourceComponent = eventSource;
                        eventSourceComponent.setFont(eventSourceComponent.getFont().deriveFont(3));
                        eventSourceComponent.setForeground(Color.red);
                    }
                }
lbl55:
                // 7 sources

                if (this.propertyChangeSupport != null && validValue) {
                    this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.propertiesBeingFired.remove(propertyName);
    }

    private static boolean isBoolean(Class propertyType) {
        return Boolean.class.isAssignableFrom(propertyType) || propertyType.getName().equals("boolean");
    }

    public void modelUpdated() {
        if (this.updatingModel) {
            return;
        }
        this.updatingModel = true;
        boolean nullModel = this.model == null;
        for (String propertyName : this.propertiesTypes.keySet()) {
            try {
                Class propertyType = this.getPropertyType(propertyName);
                Object value = this.model == null ? null : this.getGetterMethod(propertyName).invoke(this.model, new Object[0]);
                for (JComponent view : this.viewsByPropertyName.get(propertyName)) {
                    JTextComponent tc;
                    if (String.class.isAssignableFrom(propertyType)) {
                        tc = (JTextComponent)view;
                        String svalue = (String)value;
                        tc.setText(svalue == null ? "" : svalue);
                        tc.setEnabled(!nullModel);
                        continue;
                    }
                    if (BeansController.isBoolean(propertyType)) {
                        AbstractButton cb = (AbstractButton)view;
                        Boolean bvalue = (Boolean)value;
                        cb.setEnabled(!nullModel);
                        cb.setSelected(bvalue != null && bvalue != false);
                        continue;
                    }
                    if (!BeansController.isInteger(propertyType)) continue;
                    tc = (JTextComponent)view;
                    Integer ivalue = (Integer)value;
                    tc.setText(ivalue == null ? "" : ivalue.toString());
                    tc.setEnabled(!nullModel);
                }
            }
            catch (Exception ex) {
                System.err.println("Error while updating views for property '" + propertyName + "' of model " + this.modelClass.getName());
                ex.printStackTrace();
            }
        }
        this.updatingModel = false;
    }

    private static final boolean isInteger(Class c) {
        return Integer.class.isAssignableFrom(c);
    }

    static final String getGetterMethodName(String field) {
        return "get" + BeansController.capitalizeFirstLetter(field);
    }

    static final String getIsGetterMethodName(String field) {
        return "is" + BeansController.capitalizeFirstLetter(field);
    }

    static final String getSetterMethodName(String field) {
        return "set" + BeansController.capitalizeFirstLetter(field);
    }

    static final String capitalizeFirstLetter(String s) {
        int sLength = s.length();
        if (sLength <= 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }
}

