import javafx.application.*;
import javafx.stage.*;
import javafx.scene.*;
import javafx.scene.canvas.*;
import javafx.scene.control.*;
import javafx.scene.control.Alert.*;
import javafx.scene.effect.*;
import javafx.scene.image.*;
import javafx.scene.input.*;
import javafx.scene.layout.*;
import javafx.scene.paint.*;
import javafx.scene.shape.*;
import javafx.scene.text.*;
import javafx.beans.property.*;
import javafx.beans.value.*;
import javafx.event.*; 
import javafx.animation.*;
import javafx.geometry.*;
import java.io.*;
import java.util.*;
import javafx.scene.transform.*;

import java.text.DecimalFormat;
//import javafx.scene.media.*;

public class CookieClicker extends Application 
{
    /**
     * Name: Jack Demm
     * Final Project
     * 17 December 2016 
     * Description: 
     *     This is a JavaFx version of Cookie Clicker.
     *     
     * Submitted: December 19, 2016
     */

    public static void main(String[] args) 
    {
        // Automatic VM reset, thanks to Joseph Rachmuth.
        try
        {
            launch(args);
            System.exit(0);
        }
        catch (Exception error)
        {
            error.printStackTrace();
            System.exit(0);
        }
    }

    long previousTime;
    double deltaTime; 
    double seconds;
    int cookiesClicked;
    double totalCookies;
    Double cookiesPerSecond = new Double(0);

    double timer;

    double autoCookieCount;

    HashMap<String, Image> imageStorage;

    ImageView acView;
    ImageView gmaView;
    ImageView fcartView;
    ImageView bView;
    ImageView fView;
    ImageView elfView;

    // User Power-Ups
    int clickPower;

    // THINGS FOR THE AUTO-CLICKER ++++++++++++++++++++++++++++++++
    // Auto-Clicker number
    int autoClickerNum;

    // Auto-Clicker Prices
    int autoClickerPrice;

    // Auto-Clicker generator amounts
    double autoClickerCookies;

    // Auto Clicker percentages
    double acdecimal;

    double autoClickerMultiplier;

    //THINGS FOR THE GRANDMA ITEM+++++++++++++++++++++++++++++++++++++
    int grandmaNum;
    int grandmaPrice;
    double grandmaCookies;
    double grandmaDecimal;

    //THINGS FOR THE BakeSale ITEM+++++++++++++++++++++++++++++++++++++
    int fcartNum;
    int fcartPrice;
    double fcartCookies;
    double fcartDecimal;

    //THINGS FOR THE Bakery ITEM+++++++++++++++++++++++++++++++++++++
    int bNum;
    int bPrice;
    double bCookies;
    double bDecimal;

    //THINGS FOR THE Factory ITEM+++++++++++++++++++++++++++++++++++++
    int fNum;
    int fPrice;
    double fCookies;
    double fDecimal;

    //THINGS FOR THE Keebler ITEM+++++++++++++++++++++++++++++++++++++
    int elfNum;
    int elfPrice;
    double elfCookies;
    double elfDecimal;

    // THINGS FOR THE 2X CLICKS THING ++++++++++++++++++++++++++++++++
    // 30 SECOND UPGRADE
    boolean doubleTime;
    double timeClock;
    int doubleTimePrice;
    double dtDecimal;

    // 2X AUTO CLICKER
    int ac2xPrice;
    boolean ac2xTF;

    public void start(Stage mainStage) 
    {
        // Title the window
        mainStage.setTitle("Cookie Clicker FX!");

        
        // USE THIS STYLE, minimizing the window speeds up the game for some reason.
        mainStage.initStyle(StageStyle.UTILITY);

        // Create a BorderPane
        BorderPane rootBP = new BorderPane();

        // Create 2 VBoxes and an HBox
        VBox root = new VBox();
        root.setPadding( new Insets(16) );
        root.setSpacing(16);
        root.setAlignment( Pos.CENTER );

        //         VBox pictureBox = new VBox();
        //         pictureBox.setPadding( new Insets(32) );
        //         pictureBox.setSpacing(32);
        //         pictureBox.setAlignment( Pos.CENTER );
        // 
        //         VBox pictureDescriptionBox = new VBox();
        //         pictureDescriptionBox.setPadding( new Insets(32) );
        //         pictureDescriptionBox.setSpacing(32);
        //         pictureDescriptionBox.setAlignment( Pos.CENTER );

        //         HBox statsBar = new HBox();
        //         statsBar.setPadding( new Insets(16) );
        //         statsBar.setSpacing(16);
        //         statsBar.setAlignment( Pos.CENTER );

        // Create a mainScene using the BorderPane.
        Scene mainScene = new Scene(rootBP,800,800);
        mainStage.setScene(mainScene);

        // Add the VBox to the BorderPane.
        // rootBP.setBottom(hRoot);

        // add stylesheet to program
        mainScene.getStylesheets().add("assets/stylesheet.css");

        // add application icon
        mainStage.getIcons().add( new Image("assets/cookie.png") );

        imageStorage = new HashMap<String,Image>();
        imageStorage.put("ac", new Image("assets/mouse2.png") );
        imageStorage.put("gma", new Image("assets/gran.png") );
        imageStorage.put("fcart", new Image("assets/sale.png") );
        imageStorage.put("b", new Image("assets/bakery2.png") );
        imageStorage.put("f", new Image("assets/factory22.png") );  
        imageStorage.put("elf", new Image("assets/elf2.png") );

        imageStorage.put("gMouse", new Image("assets/mouseGold.png") );

        // custom code below --------------------------------------------

        DecimalFormat df = new DecimalFormat("###,###,###,##0.000");

        // Used for deltatime
        previousTime = System.nanoTime();

        // Used to calculate cookies per second.
        cookiesClicked = 0;

        // Total amount of cookies currently.
        totalCookies = 0;

        // How many cookies generated per click.
        clickPower = 1;

        // Total number of cookies generated automatically.
        autoCookieCount = 0;

        // Setting the inital price of different items.
        autoClickerPrice = 20;
        doubleTimePrice = 2500;
        grandmaPrice = 250;
        fcartPrice = 1000;
        bPrice = 5000;
        fPrice = 20000;
        elfPrice = 100000;

        ac2xPrice = 500;

        // Increasing price of item per-purchase.
        DecimalFormat dfItems = new DecimalFormat("###,###,###,##0.0");
        acdecimal = 0.05;
        dtDecimal = 0.10;
        grandmaDecimal= 0.05;
        fcartDecimal = 0.04;
        bDecimal = 0.04;
        fDecimal = 0.08;
        elfDecimal = 0.15;

        //Multipliers go here
        autoClickerMultiplier = 0.001;

        // Needed labels.
        Label numCookiesLabel = new Label("");
        Label totalCookiesLabel = new Label("");
        Label timeLabel = new Label("");
        // rootBP.setBottom(timeLabel);

        //ITEM LABELS
        Label acLabel = new Label("");
        Label gmaLabel = new Label("");
        Label fcartLabel = new Label("");
        Label bLabel = new Label("");
        Label fLabel = new Label("");
        Label elfLabel = new Label("");

        acView = new ImageView();
        gmaView = new ImageView();
        fcartView = new ImageView();
        bView = new ImageView();
        fView = new ImageView();
        elfView = new ImageView();

        acView.setImage(imageStorage.get("ac"));
        acView.setVisible(false);
        gmaView.setImage(imageStorage.get("gma"));
        gmaView.setVisible(false);
        fcartView.setImage(imageStorage.get("fcart"));
        fcartView.setVisible(false);
        bView.setImage(imageStorage.get("b"));
        bView.setVisible(false);
        fView.setImage(imageStorage.get("f"));
        fView.setVisible(false);
        elfView.setImage(imageStorage.get("elf"));
        elfView.setVisible(false);

        GridPane gPane = new GridPane();
        gPane.setHgap(16);
        gPane.setVgap(16);
        gPane.setAlignment(Pos.CENTER);

        gPane.add(acView,0,0);
        gPane.add(gmaView,2,0);
        gPane.add(fcartView,4,0);
        gPane.add(bView,0,1);
        gPane.add(fView,2,1);
        gPane.add(elfView,4,1);

        gPane.add(acLabel,1,0);
        gPane.add(gmaLabel,3,0);
        gPane.add(fcartLabel,5,0);
        gPane.add(bLabel,1,1);
        gPane.add(fLabel,3,1);
        gPane.add(elfLabel,5,1);

        // gPane.setGridLinesVisible(true);

        gPane.setHalignment(acView, HPos.CENTER); 
        gPane.setValignment(acView, VPos.CENTER);

        gPane.setHalignment(gmaView, HPos.CENTER); 
        gPane.setValignment(gmaView, VPos.CENTER);

        gPane.setHalignment(fcartView, HPos.CENTER); 
        gPane.setValignment(fcartView, VPos.CENTER);

        gPane.setHalignment(bView, HPos.CENTER); 
        gPane.setValignment(bView, VPos.CENTER);

        gPane.setHalignment(fView, HPos.CENTER); 
        gPane.setValignment(fView, VPos.CENTER);

        gPane.setHalignment(elfView, HPos.CENTER); 
        gPane.setValignment(elfView, VPos.CENTER);

        gPane.setHalignment(acLabel, HPos.CENTER); 
        gPane.setValignment(acLabel, VPos.CENTER);

        gPane.setHalignment(gmaLabel, HPos.CENTER); 
        gPane.setValignment(gmaLabel, VPos.CENTER);

        gPane.setHalignment(fcartLabel, HPos.CENTER); 
        gPane.setValignment(fcartLabel, VPos.CENTER);

        gPane.setHalignment(bLabel, HPos.CENTER); 
        gPane.setValignment(bLabel, VPos.CENTER);

        gPane.setHalignment(fLabel, HPos.CENTER); 
        gPane.setValignment(fLabel, VPos.CENTER);

        gPane.setHalignment(elfLabel, HPos.CENTER); 
        gPane.setValignment(elfLabel, VPos.CENTER);

        numCookiesLabel.setAlignment(Pos.CENTER_LEFT);
        totalCookiesLabel.setAlignment(Pos.CENTER_LEFT);
        timeLabel.setAlignment(Pos.CENTER_LEFT);

        // THE COOKIE AND ALL ITS GLORY! +++++++++++++++++++++++++++++++++++++++++++++++++++++!+!+!+!+!+++++++!+!+!+!
       // AudioClip clickSound = new AudioClip( new File("assets/click.mp3").toURI().toString() );
        Button cookieButton = new Button();
        cookieButton.setOnAction( 
            new EventHandler<ActionEvent>()
            {
                public void handle(ActionEvent event)
                {
                   // clickSound.play();
                    cookiesClicked = cookiesClicked + clickPower;
                    totalCookies = totalCookies + clickPower;
                }
            }
        );
        cookieButton.setGraphic( new ImageView( new Image("assets/cookie.png") ) );
        cookieButton.getStyleClass().add("cookie");

        rootBP.setCenter(root);

        // menu bar code --------------------------------------------------
        // Create a menuBar and add it to root.
        MenuBar menuBar = new MenuBar();
        rootBP.setTop(menuBar);

        // Create a menu called File
        Menu menuInfo = new Menu("File");
        menuBar.getMenus().add(menuInfo);

        Menu menuBuy = new Menu("Buy Item");
        menuBar.getMenus().add(menuBuy);

        //         Menu menuUpgrades = new Menu("Buy Upgrade");
        //         menuBar.getMenus().add(menuUpgrades);

        // AUTO CLICKER EVENT !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        MenuItem menuItemAutoClicker = new MenuItem("Auto Click- c$" + autoClickerPrice);
        menuItemAutoClicker.setOnAction( 
            new EventHandler<ActionEvent>()
            {
                public void handle(ActionEvent event)
                {
                    autoClickerNum++;
                    acLabel.setText("X " + autoClickerNum);
                    totalCookies = totalCookies - autoClickerPrice;
                    Double acPrice = (double)autoClickerPrice;
                    autoClickerPrice = (int)(autoClickerPrice + (acPrice * acdecimal));
                    acdecimal += 0.02;

                    autoClickerCookies += autoClickerMultiplier;

                    menuItemAutoClicker.setText("Auto Click- c$" + autoClickerPrice);
                    acView.setVisible(true);
                    acLabel.setText(" X " + autoClickerNum);
                }
            }
        );
        menuItemAutoClicker.setGraphic( new ImageView( new Image("assets/mouse2.png") ) );

        menuBuy.getItems().add(menuItemAutoClicker);

        // GRANDMA EVENT !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        MenuItem menuItemGma = new MenuItem("Grandma- c$" + grandmaPrice);
        menuItemGma.setOnAction( 
            new EventHandler<ActionEvent>()
            {
                public void handle(ActionEvent event)
                {
                    grandmaNum++;
                    gmaLabel.setText("X " + grandmaNum);
                    totalCookies = totalCookies - grandmaPrice;
                    Double gPrice = (double)grandmaPrice;
                    grandmaPrice = (int)(grandmaPrice + (gPrice * grandmaDecimal));
                    grandmaDecimal += 0.02;

                    grandmaCookies += 0.020;

                    menuItemGma.setText("Grandma- c$" + grandmaPrice);
                    gmaView.setVisible(true);
                    gmaLabel.setText(" X " + grandmaNum);
                }
            }
        );
        menuItemGma.setGraphic( new ImageView( new Image("assets/gran.png") ) );

        menuBuy.getItems().add(menuItemGma);

        // Bake Sale EVENT !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        MenuItem menuItemfcart = new MenuItem("Bake Sale- c$" + fcartPrice);
        menuItemfcart.setOnAction( 
            new EventHandler<ActionEvent>()
            {
                public void handle(ActionEvent event)
                {
                    fcartNum++;
                    fcartLabel.setText("X " + fcartNum);
                    totalCookies = totalCookies - fcartPrice;
                    Double fcPrice = (double)fcartPrice;
                    fcartPrice = (int)(fcartPrice + (fcPrice * fcartDecimal));
                    fcartDecimal += 0.02;

                    fcartCookies += 0.100;

                    menuItemfcart.setText("Bake Sale- c$" + fcartPrice);
                    fcartView.setVisible(true);
                    fcartLabel.setText(" X " + fcartNum);
                }
            }
        );
        menuItemfcart.setGraphic( new ImageView( new Image("assets/sale.png") ) );

        menuBuy.getItems().add(menuItemfcart);

        // Bakery EVENT !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        MenuItem menuItemb = new MenuItem("Bakery- c$" + bPrice);
        menuItemb.setOnAction( 
            new EventHandler<ActionEvent>()
            {
                public void handle(ActionEvent event)
                {
                    bNum++;
                    bLabel.setText("X " + bNum);
                    totalCookies = totalCookies - bPrice;
                    Double bbPrice = (double)bPrice;
                    bPrice = (int)(bPrice + (bbPrice * bDecimal));
                    bDecimal += 0.02;

                    bCookies += 1.000;

                    menuItemb.setText("Bakery- c$" + bPrice);
                    bView.setVisible(true);
                    bLabel.setText(" X " + bNum);
                }
            }
        );
        menuItemb.setGraphic( new ImageView( new Image("assets/bakery2.png") ) );

        menuBuy.getItems().add(menuItemb);

        // Factory EVENT !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        MenuItem menuItemf = new MenuItem("Cookie Factory- c$" + fPrice);
        menuItemf.setOnAction( 
            new EventHandler<ActionEvent>()
            {
                public void handle(ActionEvent event)
                {
                    fNum++;
                    fLabel.setText("X " + fNum);
                    totalCookies = totalCookies - fPrice;
                    Double ffPrice = (double)fPrice;
                    fPrice = (int)(fPrice + (ffPrice * fDecimal));
                    fDecimal += 0.02;

                    fCookies += 8.000;

                    menuItemf.setText("Cookie Factory- c$" + fPrice);
                    fView.setVisible(true);
                    fLabel.setText(" X " + fNum);
                }
            }
        );
        menuItemf.setGraphic( new ImageView( new Image("assets/factory22.png") ) );

        menuBuy.getItems().add(menuItemf);

        // Keebler EVENT !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        MenuItem menuItemElf = new MenuItem("Keebler Elf- c$" + elfPrice);
        menuItemElf.setOnAction( 
            new EventHandler<ActionEvent>()
            {
                public void handle(ActionEvent event)
                {
                    elfNum++;
                    elfLabel.setText("X " + elfNum);
                    totalCookies = totalCookies - elfPrice;
                    Double elffPrice = (double)elfPrice;
                    elfPrice = (int)(elfPrice + (elffPrice * elfDecimal));
                    elfDecimal += 0.02;

                    elfCookies += 50.000;

                    menuItemElf.setText("Keebler Elft- c$" + elfPrice);
                    elfView.setVisible(true);
                    elfLabel.setText(" X " + elfNum);
                }
            }
        );
        menuItemElf.setGraphic( new ImageView( new Image("assets/elf2.png") ) );

        menuBuy.getItems().add(menuItemElf);

        SeparatorMenuItem sepItem = new SeparatorMenuItem();
        menuBuy.getItems().add(sepItem);

        // 2X CLICKS ------------------------------------------------------------------------------------

        timeClock = 0;
        doubleTime = false;

        MenuItem menuItemTempDoubler = new MenuItem("Clicks 2X- c$"+ doubleTimePrice);
        menuItemTempDoubler.setOnAction( 
            new EventHandler<ActionEvent>()
            {
                public void handle(ActionEvent event)
                {

                    //                     if(totalCookies >= doubleTimePrice){
                    //                         doubleTime = true;
                    //                         // menuItemTempDoubler.setDisable(false);
                    // 
                    //                     }
                    //                     else if (totalCookies < doubleTimePrice){
                    //                         menuItemTempDoubler.setDisable(true);
                    //                         doubleTime = false;
                    //                     }
                    // 
                    //                     doubleTime = true;
                    //                     totalCookies = totalCookies - doubleTimePrice;
                    //                     Double dtPrice = (double)doubleTimePrice;
                    //                     doubleTimePrice = (int)(doubleTimePrice + (dtPrice * dtDecimal));
                    //                     dtDecimal += 0.10;
                    // 
                    //                     timeClock = 30;
                    // 
                    //                     menuItemTempDoubler.setText("Clicks 2X for 30s- c$" + doubleTimePrice);

                    totalCookies = totalCookies - doubleTimePrice;
                    clickPower = 2;
                    acView.setImage(imageStorage.get("gMouse"));
                    menuItemTempDoubler.setDisable(true);
                    doubleTime = true;

                }
            }
        );
        // menuItemHelp.setGraphic( new ImageView( new Image("assets/help.png") ) );

        menuBuy.getItems().add(menuItemTempDoubler);

        if (totalCookies < doubleTimePrice){
            menuItemTempDoubler.setDisable(true);

        }

        // 2X PERMENANT AUTO CLICKER ========================================================================================================
        ac2xTF = false;
        MenuItem menuItemAC2x = new MenuItem("Auto Clicker 2X- c$"+ ac2xPrice);
        menuItemAC2x.setOnAction( 
            new EventHandler<ActionEvent>()
            {
                public void handle(ActionEvent event)
                {

                    totalCookies = totalCookies - ac2xPrice;

                    autoClickerCookies = autoClickerCookies * 2;

                    autoClickerMultiplier = 0.002;

                    acView.setImage(imageStorage.get("gMouse"));
                    menuItemAC2x.setDisable(true);
                    ac2xTF = true;
                }
            }
        );
        // menuItemHelp.setGraphic( new ImageView( new Image("assets/help.png") ) );

        menuBuy.getItems().add(menuItemAC2x);

        // This variable allows the user to actually see cookies per second;
        timer = 0;

        new AnimationTimer()
        {
            public void handle(long currentTime)
            {
                // Thanks for deltaTime Lee!
                deltaTime = (currentTime - previousTime) / 1000000000.0;
                previousTime = currentTime;

                // seconds += 1;

                timer += deltaTime;

                cookiesPerSecond = (cookiesClicked / 1) + (autoClickerCookies * 100) + (grandmaCookies * 100) + (fcartCookies * 100) + (bCookies * 100) + (fCookies * 100) + (elfCookies * 100);
                String cookiesPerSecondString = String.valueOf(df.format(cookiesPerSecond));

                String totalCookiesString = String.valueOf(df.format(totalCookies));
                totalCookiesLabel.setText("Total Cookies: " + totalCookiesString);

                // ADDING THE COOKIES ``````````````````````````````````````````````````````````````````````````````````````
                totalCookies += autoClickerCookies + grandmaCookies + fcartCookies + bCookies + fCookies + elfCookies;


                if(totalCookies >= autoClickerPrice){
                    menuItemAutoClicker.setDisable(false);
                }
                else if (totalCookies < autoClickerPrice){menuItemAutoClicker.setDisable(true);}

                if(totalCookies >= grandmaPrice){
                    menuItemGma.setDisable(false);
                }
                else if (totalCookies < grandmaPrice){menuItemGma.setDisable(true);}

                if(totalCookies >= fcartPrice){
                    menuItemfcart.setDisable(false);
                }
                else if (totalCookies < fcartPrice){menuItemfcart.setDisable(true);}

                if(totalCookies >= fPrice){
                    menuItemf.setDisable(false);
                }
                else if (totalCookies < fPrice){menuItemf.setDisable(true);}

                if(totalCookies >= bPrice){
                    menuItemb.setDisable(false);
                }
                else if (totalCookies < bPrice){menuItemb.setDisable(true);}

                if(totalCookies >= elfPrice){
                    menuItemElf.setDisable(false);
                }
                else if (totalCookies < elfPrice){menuItemElf.setDisable(true);}

                // Only update cookies per second at 1 second intervals, so user can actually
                // read the information!
                if(timer >= 1)
                {

                    numCookiesLabel.setText("Cookies Per Second: " + cookiesPerSecondString);
                    cookiesClicked = 0;
                    timer = 0;
                }

                //                 if((timeClock > 0 && doubleTime == true)){
                //                     doubleTime = true;
                //                     timeClock -= deltaTime;
                //                     DecimalFormat dfTimer = new DecimalFormat("00");
                //                     timeLabel.setVisible(true);
                //                     timeLabel.setText("Time Remaining: " + dfTimer.format(timeClock) + "s");
                //                     clickPower = 2;
                //                     menuItemTempDoubler.setDisable(false);
                //                 }
                //                 else if((timeClock <= 0 && doubleTime == true) ){
                //                     doubleTime = false;
                //                     timeLabel.setVisible(false);
                //                     clickPower = 1;
                //                     menuItemTempDoubler.setDisable(true);
                //                 }

                if(ac2xTF == false && totalCookies >= ac2xPrice){
                    menuItemAC2x.setDisable(false);
                }
                else if (ac2xTF == false && totalCookies < ac2xPrice){menuItemAC2x.setDisable(true);}

                if(doubleTime == false && totalCookies >= doubleTimePrice){
                    menuItemTempDoubler.setDisable(false);
                }
                else if (doubleTime == false && totalCookies < doubleTimePrice){menuItemTempDoubler.setDisable(true);}

            }
        }.start();

        // Add the two VBoxes to the HBox, and all the objects to the VBoxes.
        //  statsBar.getChildren().addAll(totalCookiesLabel,numCookiesLabel);

        // rootBP.setBottom(statsBar);

        // rootBP.setLeft(totalCookiesLabel);
        // rootBP.setLeft(numCookiesLabel);

        root.getChildren().addAll(timeLabel,totalCookiesLabel, numCookiesLabel,cookieButton, gPane );
        // root2.getChildren().addAll(textTx,textTy,textRx,textRy,textRz,textColor);
        // custom code above --------------------------------------------

        // Help MenuItem---------------------------------------------------------------------------------------- 
        // Create a menuItem that, when clicked, will create a pop-up with instructions. Also, add a key-combo to activate the help pop-up. Lastly, add icon to the menuItem.
        MenuItem menuItemHelp = new MenuItem("How to use this program...");
        menuItemHelp.setOnAction( 
            new EventHandler<ActionEvent>()
            {
                public void handle(ActionEvent event)
                {
                    Alert infoAlert = new Alert(AlertType.INFORMATION);
                    infoAlert.setTitle("Help");
                    infoAlert.setHeaderText(null);

                    String message = "Click the Cookie to make cookies! Buy Items to make even more cookies! ";

                    infoAlert.setContentText(message);
                    infoAlert.showAndWait();
                }
            }
        );
        menuItemHelp.setGraphic( new ImageView( new Image("assets/help.png") ) );
        menuItemHelp.setAccelerator(
            new KeyCodeCombination(KeyCode.H, KeyCombination.CONTROL_DOWN) );
        menuInfo.getItems().add(menuItemHelp);

        // About MenuItem----------------------------------------------------------------------------------------
        // Create a menuItem that, when clicked, will create a pop-up with the program's credits.  Also, add a key-combo to activate the about pop-up. Lastly, add icon to the menuItem.
        MenuItem menuItemAbout = new MenuItem("About this program...");
        menuItemAbout.setOnAction( 
            new EventHandler<ActionEvent>()
            {
                public void handle(ActionEvent event)
                {
                    Alert infoAlert = new Alert(AlertType.INFORMATION);
                    infoAlert.setTitle("About This Program...");
                    infoAlert.setHeaderText(null);

                    String message = "Cookie Clicker FX!, by Jack Demm";

                    infoAlert.setContentText(message);
                    infoAlert.showAndWait();
                }
            }
        );
        menuItemAbout.setGraphic( new ImageView( new Image("assets/information.png") ) );
        menuItemAbout.setAccelerator(
            new KeyCodeCombination(KeyCode.A, KeyCombination.CONTROL_DOWN) );
        menuInfo.getItems().add(menuItemAbout);

        // Quit MenuItem----------------------------------------------------------------------------------------
        // Create a menuItem that, when clicked, will quit the program.  Also, add a key-combo to also quit the program. Lastly, add icon to the menuItem.
        MenuItem menuItemQuit = new MenuItem("Quit");
        menuItemQuit.setOnAction( 
            new EventHandler<ActionEvent>()
            {
                public void handle(ActionEvent event)
                {
                    mainStage.close();
                }
            }
        );
        menuItemQuit.setGraphic( new ImageView( new Image("assets/cancel.png") ) );
        menuItemQuit.setAccelerator(
            new KeyCodeCombination(KeyCode.Q, KeyCombination.CONTROL_DOWN) );
        menuInfo.getItems().add(menuItemQuit);

        mainStage.show();
    }

}
